
Branch_Theme = {
	Welcomewaiei = function()
		if GetUserPref_Theme("D3NEXThemeVersion") ~= nil then
			local s=GetUserPref_Theme("D3NEXThemeVersion");
			local n=(""..GetThemeVersionInformation("Version"))
			if s~=n then
				SetUserPref_Theme("D3NEXThemeVersion",GetThemeVersionInformation("Version"));
				return Branch.AfterInit();
			else
				return Branch.AfterInit();
			end;
		else
			SetUserPref_Theme("D3NEXThemeVersion",GetThemeVersionInformation("Version"));
			return Branch.AfterInit();
		end;
	end,
	AfterProfileSave = function()
		if GAMESTATE:IsEventMode() then
			return SelectMusicOrCourse()
		elseif STATSMAN:GetCurStageStats():AllFailed() or GAMESTATE:IsCourseMode() then
			if GAMESTATE:GetCurrentStageIndex()<2 then
				return "ScreenGameOver"
			else
				return "ScreenEvaluationSummary"
			end;
		elseif GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer() == 0 then
			return "ScreenEvaluationSummary"
		else
			return SelectMusicOrCourse()
		end
	end,
	AfterSummary = function()
		return "ScreenProfileSaveSummary"
	end,
	AfterSelectProfile = function()
		if IsAutoSetStyle() then
			if IsNetConnected() then
				return "ScreenSelectStyle";
			end;
			return "ScreenSelectPlayMode";
		else
			return "ScreenSelectStyle";
		end;
	end,
	AfterSelectPlayMode = function()
		if IsAutoSetStyle() then
			return "ScreenSelectPlayMode";
		else
			return "ScreenSelectStyle";
		end;
	end,
	AfterSelectStyle = function()
		if IsNetConnected() then
			ReportStyle()
			GAMESTATE:ApplyGameCommand("playmode,regular")
		end
		if IsNetSMOnline() then
			return SMOnlineScreen()
		end
		if IsNetConnected() then
			return "ScreenNetRoom";
		end
		if IsAutoSetStyle() then
			if getenv("PlayModeDrill") then
				return "ScreenSelectDrillCategory";
			--[[
			_SYS(getenv("PlayMode"))
				if getenv("PlayMode")~="Course" then
					return "ScreenSelectDrillCategory";
				else
					return "ScreenSelectCourse";
				end;
				--]]
			end;
			return "ScreenSelectMusic";
		else
			return "ScreenSelectPlayMode";
		end;
	end,
	AfterPlayMode_Normal = function()
		if IsAutoSetStyle() then
			if GAMESTATE:GetNumPlayersEnabled()<2 then
				GAMESTATE:ApplyGameCommand("style,single",GAMESTATE:GetMasterPlayerNumber());
				GAMESTATE:ApplyGameCommand("name,Single",GAMESTATE:GetMasterPlayerNumber());
				GAMESTATE:ApplyGameCommand("text,Single",GAMESTATE:GetMasterPlayerNumber());
			else
				-- [ja] なぜか落ちる 
				--GAMESTATE:ApplyGameCommand("style,versus",GAMESTATE:GetMasterPlayerNumber());
				GAMESTATE:ApplyGameCommand("name,Versus",GAMESTATE:GetMasterPlayerNumber());
				GAMESTATE:ApplyGameCommand("text,Versus",GAMESTATE:GetMasterPlayerNumber());
				if GAMESTATE:GetMasterPlayerNumber()==PLAYER_1 then
					if not GAMESTATE:IsPlayerEnabled(PLAYER_2) then
						GAMESTATE:JoinPlayer(PLAYER_2);
					end;
				else
					if not GAMESTATE:IsPlayerEnabled(PLAYER_1) then
						GAMESTATE:JoinPlayer(PLAYER_1);
					end;
				end;
			--]]
			end;
		end;
		if IsNetSMOnline() then
			return "ScreenNetSelectMusic";
		else
			return "ScreenSelectMusic";
		end;
	end,
	AfterPlayMode_Course = function()
		if IsAutoSetStyle() then
			return "ScreenSetCourseAndBeforeSelectStyle";
		else
			return "ScreenSelectCourse";
		end;
	end,
	AfterPlayMode_Drill = function()
		if IsAutoSetStyle() then
			return "ScreenSetDrillAndBeforeSelectStyle";
		else
			return "ScreenSelectDrillCategory";
		end;
	end,
	PlayerOptions = function()
		local pm = GAMESTATE:GetPlayMode()
		local restricted = { "PlayMode_Rave",
			--"PlayMode_Battle" -- ??
		}
		local optionsScreen = "ScreenPlayerOptions"
		for i=1,#restricted do
			if restricted[i] == pm then
				optionsScreen = "ScreenPlayerOptionsRestricted"
			end
		end
		if SCREENMAN:GetTopScreen():GetGoToOptions() then
			return optionsScreen
		else
			return "ScreenStageInformation"
		end
	end,
	SongOptions = function()
		if SCREENMAN:GetTopScreen():GetGoToOptions()
			and GAMESTATE:GetPlayMode() ~= "PlayMode_Oni" 
			and not GAMESTATE:IsAnExtraStage()
			and not getenv("Drill") then
			return "ScreenSongOptions"
		else
			return "ScreenStageInformation"
		end
	end,
	StartGame = function()
		-- Check to see if there are 0 songs installed. Also make sure to check
		-- that the additional song count is also 0, because there is
		-- a possibility someone will use their existing StepMania simfile
		-- collection with sm-ssc via AdditionalFolders/AdditionalSongFolders.
		if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
			return "ScreenHowToInstallSongs"
		end
		if PROFILEMAN:GetNumLocalProfiles() >= 2 or IsAutoSetStyle() then
			return "ScreenSelectProfile"
		else
			return "ScreenCaution"
		end
	end,
	AfterHowToPlay = function()
		if SONGMAN:GetNumSongs() == 0 and SONGMAN:GetNumAdditionalSongs() == 0 then
			return Branch.Init();
		else
			return "ScreenDemonstration"
		end
	end,
 	AfterSaveSummary = function()
		return "ScreenGameOver"
--		[[ Enable when Finished ]]
-- 		return GAMESTATE:AnyPlayerHasRankingFeats() and "ScreenNameEntryTraditional" or "ScreenGameOver"
	end,
};
